// Function to disable inputs and uncheck child checkboxes for all groups
function resetGroups(exceptGroup) {
    // Uncheck all group checkboxes except the one passed in the argument
    $('#category, #segment, #brand, #product').not(exceptGroup).prop('checked', false);
    
    // Disable and uncheck all child checkboxes and inputs
    $('#p1, #segment1, #segment2, #segment3, #brand1, #brand2, #brand3, #product1, #product2, #product3, #product4').prop('checked', false).prop('disabled', true);
    $('#cattxt, #amnum, #psnum, #cattxt2, #amnum2, #psnum2, #cattxt3, #amnum3, #psnum3, #cattxt4, #amnum4, #psnum4, #cattxt5, #amnum5, #psnum5, #cattxt6, #amnum6, #psnum6, #cattxt7, #amnum7, #psnum7, #cattxt8, #amnum8, #psnum8, #cattxt9, #amnum9, #psnum9, #cattxt10, #amnum10, #psnum10, #cattxt11, #amnum11, #psnum11, #cattxt12, #amnum12, #psnum12').prop('disabled', true);
}

// When any group checkbox is clicked
$('#category, #segment, #brand, #product').on('change', function() {
    // Reset all groups except the one that was clicked
    resetGroups(this);
    
    // Enable child checkboxes and inputs based on the selected group
    if (this.id === 'category' && this.checked) {
        $('#p1').prop('disabled', false).prop('checked', false);
    } else if (this.id === 'segment' && this.checked) {
        $('#segment1, #segment2, #segment3').prop('disabled', false).prop('checked', false);
    } else if (this.id === 'brand' && this.checked) {
        $('#brand1, #brand2, #brand3').prop('disabled', false).prop('checked', false);
    } else if (this.id === 'product' && this.checked) {
        $('#product1, #product2, #product3, #product4').prop('disabled', false).prop('checked', false);
    }
});

// Event handlers for child checkboxes
$('#p1').on('change', function() {
    const isChecked = this.checked;
    $('#cattxt, #amnum, #psnum').prop('disabled', !isChecked);
});

$('#segment1, #segment2, #segment3').on('change', function() {
    const isChecked = this.checked;
    const segmentId = $(this).attr('id');
    
    if (segmentId === 'segment1') {
        $('#cattxt2, #amnum2, #psnum2').prop('disabled', !isChecked);
    } else if (segmentId === 'segment2') {
        $('#cattxt3, #amnum3, #psnum3').prop('disabled', !isChecked);
    } else if (segmentId === 'segment3') {
        $('#cattxt4, #amnum4, #psnum4').prop('disabled', !isChecked);
    }
});

$('#brand1, #brand2, #brand3').on('change', function() {
    const isChecked = this.checked;
    const brandId = $(this).attr('id');
    
    if (brandId === 'brand1') {
        $('#cattxt5, #amnum5, #psnum5').prop('disabled', !isChecked);
    } else if (brandId === 'brand2') {
        $('#cattxt6, #amnum6, #psnum6').prop('disabled', !isChecked);
    } else if (brandId === 'brand3') {
        $('#cattxt7, #amnum7, #psnum7').prop('disabled', !isChecked);
    }
});

$('#product1, #product2, #product3, #product4, #product5').on('change', function() {
    const isChecked = this.checked;
    const productId = $(this).attr('id');
    
    if (productId === 'product1') {
        $('#cattxt8, #amnum8, #psnum8').prop('disabled', !isChecked);
    } else if (productId === 'product2') {
        $('#cattxt9, #amnum9, #psnum9').prop('disabled', !isChecked);
    } else if (productId === 'product3') {
        $('#cattxt10, #amnum10, #psnum10').prop('disabled', !isChecked);
    } else if (productId === 'product4') {
        $('#cattxt11, #amnum11, #psnum11').prop('disabled', !isChecked);
    } else if (productId === 'product5') {
        $('#cattxt12, #amnum12, #psnum12').prop('disabled', !isChecked);
    }
});


// When checkbox is clicked, toggle disabled state of input fields
$('#customCheck12').on('change', function() {
    if (this.checked) {
        // Enable inputs
        $('#cattxt12').prop('disabled', false);
        $('#amnum12').prop('disabled', false);
        $('#psnum12').prop('disabled', false);
    } else {
        // Disable inputs
        $('#cattxt12').prop('disabled', true);
        $('#amnum12').prop('disabled', true);
        $('#psnum12').prop('disabled', true);
    }
});

// When checkbox is clicked, toggle disabled state of input fields
$('#customCheck13').on('change', function() {
    if (this.checked) {
        // Enable inputs
        $('#display').prop('disabled', false);
    } else {
        // Disable inputs
        $('#display').prop('disabled', true);
    }
});

// When checkbox is clicked, toggle disabled state of input fields
$('#customCheck14').on('change', function() {
    if (this.checked) {
        // Enable inputs
        $('#feature').prop('disabled', false);
    } else {
        // Disable inputs
        $('#feature').prop('disabled', true);
    }
});

// When checkbox is clicked, toggle disabled state of input fields
$('#customCheck15').on('change', function() {
    if (this.checked) {
        // Enable inputs
        $('#listing').prop('disabled', false);
    } else {
        // Disable inputs
        $('#listing').prop('disabled', true);
    }
});

// When checkbox is clicked, toggle disabled state of input fields
$('#customCheck16').on('change', function() {
    if (this.checked) {
        // Enable inputs
        $('#other').prop('disabled', false);
    } else {
        // Disable inputs
        $('#other').prop('disabled', true);
    }
});

// When checkbox is clicked, toggle disabled state of input fields
$('#customCheck17').on('change', function() {
    if (this.checked) {
        // Enable inputs
        $('#time').prop('disabled', false);
        $('#time1').prop('disabled', false);
        $('#time2').prop('disabled', false);
    } else {
        // Disable inputs
        $('#time').prop('disabled', true);
        $('#time1').prop('disabled', true);
        $('#time2').prop('disabled', true);
    }
});




document.addEventListener("DOMContentLoaded", function() {
    var canvas = document.querySelector("#signature_pad");
    var signaturePad = new SignaturePad(canvas, {
        minWidth: 1,
        maxWidth: 2,
    });

    function resizeCanvas() {
        var ratio =  Math.max(window.devicePixelRatio || 1, 1);
        canvas.width = canvas.offsetWidth * ratio;
        canvas.height = canvas.offsetHeight * ratio;
        canvas.getContext("2d").scale(ratio, ratio);
        let storedData = signaturePad.toData();
        signaturePad.clear(); // otherwise isEmpty() might return incorrect value
        signaturePad.fromData(storedData);
    }

    window.addEventListener("resize", resizeCanvas);
    resizeCanvas();
    
    var clearButton = document.querySelector("#clear_button");
    clearButton.addEventListener("click", function() {
        signaturePad.clear();
    });
    
    var finishButton = document.querySelector("#finish_button");
    finishButton.addEventListener("click", function() {
        const svgDataUrl = signaturePad.toDataURL("image/svg+xml");
        console.log(svgDataUrl);
    });
});

document.addEventListener("DOMContentLoaded", function() {
    var canvas = document.querySelector("#signature_pad1");
    var signaturePad = new SignaturePad(canvas, {
        minWidth: 1,
        maxWidth: 2,
    });

    function resizeCanvas() {
        var ratio =  Math.max(window.devicePixelRatio || 1, 1);
        canvas.width = canvas.offsetWidth * ratio;
        canvas.height = canvas.offsetHeight * ratio;
        canvas.getContext("2d").scale(ratio, ratio);
        let storedData = signaturePad.toData();
        signaturePad.clear(); // otherwise isEmpty() might return incorrect value
        signaturePad.fromData(storedData);
    }

    window.addEventListener("resize", resizeCanvas);
    resizeCanvas();
    
    var clearButton = document.querySelector("#clear_button1");
    clearButton.addEventListener("click", function() {
        signaturePad.clear();
    });
    
    var finishButton = document.querySelector("#finish_button");
    finishButton.addEventListener("click", function() {
        const svgDataUrl = signaturePad.toDataURL("image/svg+xml");
        console.log(svgDataUrl);
    });
});